; NSIS2 script

!define VERSION "0.9"

Name "X-Diashow ${VERSION}"
OutFile "xdiashow-${VERSION}.exe"

XPStyle on

InstallDir $PROGRAMFILES\xdiashow
InstallDirRegKey HKLM "Software\xdiashow" "Install_Dir"

LicenseData "COPYING.txt"

Page license
Page directory
Page components
Page instfiles
UninstPage uninstConfirm
UninstPage instfiles

;
; Install
;
Section "XDiashow (Required)"

  SectionIn RO
  
  ; Set output path to the installation directory.
  SetOutPath $INSTDIR
  
  ; Put file there
	File "xdiashow.exe"
	File "COPYING.txt"
  	File "libpng12.dll"
	File "SDL.dll"
	File "SDL_gfx.dll"
	File "SDL_image.dll"
	File "zlib1.dll"
	File "xdiashow.pdf"
	File "xdiashow.nsi"
	File "cmsr.ttf"

  ; Write the installation path into the registry
  WriteRegStr HKLM SOFTWARE\xdiashow "Install_Dir" "$INSTDIR"
  
  ; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\xdiashow" "DisplayName" "XDiashow ${VERSION}"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\xdiashow" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\xdiashow" "NoModify" 1
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\xdiashow" "NoRepair" 1
  WriteUninstaller "uninstall.exe"
 
SectionEnd


;
; Optional section (can be disabled by the user)
;
Section "Start Menu Shortcuts (all users)"
	; write to all users start menu
	SetShellVarContext all

	CreateDirectory "$SMPROGRAMS\XDiashow"
	CreateShortCut "$SMPROGRAMS\XDiashow\XDiashow.lnk" "$INSTDIR\xdiashow.exe" "" "$INSTDIR\xdiashow.exe" 0
	CreateShortCut "$SMPROGRAMS\XDiashow\XDiashow-PDF.lnk" "$INSTDIR\xdiashow.pdf" "" "$INSTDIR\xdiashow.pdf" 0
	CreateShortCut "$SMPROGRAMS\XDiashow\COPYING.txt.lnk" "$INSTDIR\COPYING.txt" "" "$INSTDIR\COPYING.txt" 0
	CreateShortCut "$SMPROGRAMS\XDiashow\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
SectionEnd

;
; Optional section (create Desktop LInk)
Section "Desktop Link (current user)"
	CreateShortCut "$DESKTOP\XDiashow.lnk" "$INSTDIR\xdiashow.exe" "" "$INSTDIR\xdiashow.exe" 0
SectionEnd

;
; Optional section (create Desktop LInk)
Section /o "Desktop Link (all users)"
	SetShellVarContext all
	CreateShortCut "$DESKTOP\XDiashow.lnk" "$INSTDIR\xdiashow.exe" "" "$INSTDIR\xdiashow.exe" 0
SectionEnd

;
; Uninstaller
;
Section "Uninstall"
  ; Remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\xdiashow"
  DeleteRegKey HKLM SOFTWARE\xdiashow

  ; Remove files and uninstaller
	Delete "$INSTDIR\xdiashow.exe"
	Delete "$INSTDIR\*.dll"
	Delete "$INSTDIR\xdiashow.pdf"
	Delete "$INSTDIR\*.txt"
	Delete "$INSTDIR\xdiashow.nsi"
	Delete "$INSTDIR\uninstall.exe"
	Delete "$INSTDIR\cmsr.ttf"

	Delete "$DESKTOP\XDiashow.lnk"

	; context is the all users environment
	SetShellVarContext all

  ; Remove shortcuts, if any
	Delete "$SMPROGRAMS\XDiashow\*.*"
	Delete "$DESKTOP\XDiashow.lnk"

  ; Remove directories used
	RMDir "$SMPROGRAMS\XDiashow"
	RMDir "$INSTDIR"
SectionEnd

